classdef myTdmsReader
    methods (Static)
    %% Leggo il file TDMS e mostro i risultati in una figure apposita
    function Z=doAllTheJob(varargin)
        fileTarget = [];
        showPlots  = true;

        if nargin
        fileTarget = varargin{1};
            if nargin>1
            showPlots = varargin{2};    
            end
        end

        addpath('TDMS reader\')
        Z=myTdmsReader.estraiMicAndLC(fileTarget);
        if showPlots
            disp(Z)
            myTdmsReader.plotTDMS(Z,true)
        end
    end
    
    %% Plotto i risultati del file estratto da "estraiMicAndLC(..)"
    
    function plotTDMS(Z, showFZero)
        %showFZero = true;
        switch showFZero
            case true
                figure('Name',Z.name,'MenuBar','figure','Color','w')
                subplot(2,1,1)
                plot(Z.LC,'-')
                title('LC et al'), xlabel('Samples'), ylabel('Volt')
                l=legend(["Load Cell" "unused" "Pitot" "Contraction"]);
                l.ItemHitFcn = @myTdmsReader.ShowOnOff;
                subplot(2,1,2)
                L = Z.Properties.wf_samples;
                N = size(Z.mics,2); %16 <-mics
                colors = jet;
                colors = colors(round(linspace(1,size(colors,1),N)),:);
                for i=1:N
                    plot3(1:L, repmat(i,1,L),Z.mics(:,i)','-',...
                        'Color',colors(i,:),'DisplayName',"MicSig"+i); hold on
                end
                title('Microphones'), xlabel('Samples'),ylabel('Mic Channels'), zlabel('Volt')
                ax=gca; 
                yticks(ax,1:N);  yticklabels(ax,[]);  ylim(ax,[0 N+1])
                
                for i=1:N
                   text(ax.XLim(1)-10e3,i, ax.ZLim(1),""+i,'Color',colors(i,:)); 
                end
                ax.TickLength(2)=0;
                segnali = findobj(ax,'-not','DisplayName','');
                segnali = segnali(2:end);
                ll = legend(segnali);
                ll.ItemHitFcn = @myTdmsReader.ShowOnOff;
            case false
        end
        
    end
    
    %% Function di Callback per le legends. Mostra/nasconde i plot se si clicka sulla legenda.
    function ShowOnOff(~,evnt)
    %(?) cosa fa: questa è una function di callback utilizzata per rendere i plot 
    % associati ad una legend più interattivi, dando all'utente la
    % possibilità di nasconderli o renderli visibili quando clicka sulla
    % legend.

        
        % la tilde '~' è riferita alla source, sorgente del callback che viene
        % eseguito quando l'utente clicka su una di essa. Un esempio di
        % source potrebbe essere una scritta all'interno di una legend.
        if strcmp(evnt.Peer.Visible,'on')
            evnt.Peer.Visible = 'off'; %<-- cerca il plot associato alla legend-tag e ne modifica la visibility.
        else 
            evnt.Peer.Visible = 'on';
        end
    end
    
    %% 
    function Z=estraiMicAndLC(varargin)
        % varargin può essere il fullPathName del file *.tdms da leggere.
        % se varargin è vuoto, viene letto di default il file Zero.tdms
        
        % Il file Zero.tdms di Enrico (no wind, no forcing, semplicemente taratura).
        fZero.path  = 'C:\Users\nitro\Desktop\old tesi\I Miei Progressi\';
        fZero.file  = 'Zero.tdms';
        fZero.fullP = fZero.path+""+fZero.file;
        
        TDMSfilename = fZero.fullP;
        % Ma se l'utente mette dentro qualcos'altro lo sovrascrivo
        if ~isempty(varargin) && ischar(varargin{1})
            TDMSfilename = varargin{1};
        end
        
        [out.ConvertedData,out.ConvertVer,out.ChanNames]=convertTDMS(false,TDMSfilename);
        
        % Per capire meglio di cosa stiamo parlando, ecco alcune note:
        % disp({out.ConvertedData.Data.MeasuredData.Name })
        % "Load Cell"->(3), dummy->(4), pitot->(5), Contraction->(6)
        % "Mic1" ->(8), ..., Mic16 ->(23)
        
        % Estraggo i valori che mi interessano
        dati = out.ConvertedData.Data.MeasuredData;
        Z.mics = cat(2, dati(8:23).Data); %<-- i microfoni sulle colonne 8:23
        Z.LC   = cat(2, dati(3:6).Data); %<-- la cella di carico e il pitot sulle 3:6
        
        % Estraggo informazioni ausiliarie che potrebbero interessarmi:
        info = dati(3).Property;
        for i=[1 2 3 4 7]
            Z.Properties.(info(i).Name) = info(i).Value; %wf_start_time, wf_start_offset, etc. etc.
        end
        
        % Salvo anche in una property 'name' il nome stesso del file che ho
        % letto.
        Z.name = TDMSfilename;
    end

    %% Calcolo del CD (generico)
    function out=computeCd( simVals, atmo, ZeroMeanVals)
        % format degli input:
        % simVals = matrix [N x 2] containing {LoadCell [Volt], Contraction [Volt]}
        % atmo struct (example-> atmo.P=97700, atmo.T=294.15)
        % ZeroMeanVals = matrix [1 x 2]
        
        c1 = [0.3634, 0.0307];   %<-- fattore di conversione contrazione a pitot  A(1)x+A(2)
        c2 = [532.6654, 1.4270]; %<-- costante di taratura del trasduttore
        c3 = 1.0360;             %<-- costante di taratura della cella di carico
        c4 = 10;                 %<-- fattore di amplificazione cella di carico
        
        if ~isstruct(atmo)  %<-- se non viene fornita una struct esterna per la Atmosfera, si va con il default
            atmo = struct();
            atmo.P = 1e5; atmo.T= 15+273.15;
        end
        if ~isfield(atmo,'rho')
           atmo.rho = atmo.P / (atmo.T * 287.5); % (97700 / (294.15 x R))
        end
        
        S_ref    = 0.17*0.2;     % [m^2] superficie frontale furgone
        E_Drag_2 = simVals(:,1); % vettore [N x 1] 1° colonna su 2 del segnale, sarebbe una stima (in Volt) della forza in Newton applicata al furgone 
        E_1      = simVals(:,2); % vettore [N x 1] 2° colonna su 2 del segnale, il segnale (in Volt) della contrazione misurata dal pitot [adim] 
        
        E_Drag_0 = ZeroMeanVals(1); % è una costante: la misurazione (in Volt) della cella di carico quando la galleria e il forcing non sono attivi. (riposo) 
        E_0      = ZeroMeanVals(2); % è una costante: la misurazione (in Volt) della contrazione del tubo di pitot a riposo.
        
        delta_E_corr =    ( E_1-E_0)*c1(1) +c1(2); % vettore [N x 1] <-- delta di contrazione [adimensionale] tra la situazione a riposo (0) e quella misurata (1)
        delta_P_corr =  delta_E_corr*c2(1) +c2(2); % vettore [N x 1] <-- calo di pressione [Pascal] tra le due situazioni
        
        % OUTPUT della function
        out.Uinf = sqrt(2*delta_P_corr / atmo.rho);  % vettore [N x 1] <-- velocità a monte della galleria [m/s]
        out.Drag = (-E_Drag_2+E_Drag_0)*9.81*c3 /c4; 
        out.Cd   = out.Drag./(0.5*(out.Uinf.^2)*S_ref*atmo.rho); % \\
    end
    
    %% Calcoli al termine della simulazione
    function out = DoTheMath(channelValid, tempo, delay, Zero)
        LibT = myTdmsReader;
        out  = struct;
        
        [out.m,out.r,out.st] = LibT.meanLoadCValue([0 tempo]);
        
        if channelValid(3)
            out.del    = min(delay); %<- potrei avere delay diversi tra i 3 getti: prendo il più corto.
            out.tempo  = tempo(1);

            % 1) ottengo il valor medio dei segnali elettrici LC e Contracion:
            % a) nella prima fase, senza Forcing, tra [0s , delay]
            out.noF.LC = LibT.meanLoadCValue([0   out.del],'LC');
            out.noF.CO = LibT.meanLoadCValue([0   out.del],'CO');

            % b) nella seconda fase, con Forcing, tra [delay End]
            out.siF.LC = LibT.meanLoadCValue([out.del out.tempo],'LC');
            out.siF.CO = LibT.meanLoadCValue([out.del out.tempo],'CO');

            % 2) Da ambo le situazioni calcolo [.U_inf, .Drag, .Cd]
            out.pre  = LibT.computeCd( [out.noF.LC out.noF.CO], [], Zero);
            out.post = LibT.computeCd( [out.siF.LC out.siF.CO], [], Zero);
        else
            % SE NON HO APPLICATO FORCING l'intervallo temporale è unico [0, End]
            % Calcolo i valori medi dei segnali elettrici di LoadCell e
            % Contraction.
            out.tempo  = tempo(1);
            out.del    = out.tempo;
            out.noF.LC = LibT.meanLoadCValue([0   out.del],'LC');
            out.noF.CO = LibT.meanLoadCValue([0   out.del],'CO');

            out.siF = out.noF;
            out.pre  = LibT.computeCd( [out.noF.LC out.noF.CO], [], Zero);
            out.post = out.pre;
        end
        
        % Metto in evidenza il [.CD, .CD0, .U] delle parti che mi
        % interessano.
        out.CD  = out.post.Cd;
        out.CD0 = out.pre.Cd;
        out.U   = out.pre.Uinf;
        out.DeltaCD = out.CD-out.CD0;
        
    end

    %% Analizza un generico segnale plottato e contenuto in "PL"
    function [m,r,s]=meanLoadCValue(lim,signal)
        % (?) cosa fa: dato uno scalare o una coppia di valori temporali (lim)
        % e scelta una Animated-Line dell'interfaccia (signal, facoltativo), 
        % questa function estrae i suoi punti in funzione del tempo [t , y],
        % selezionando solo i punti che rispettano: 
        % (1) t >= lim(1);
        % (2) t <= lim(2); <- eventuale.
        % e ne calcola il valor medio, l'rms e la std.
        global PL
        segnali = ["LC" "ML" "CO"];
        
        if nargin>0
            if nargin>1
               s = validatestring(signal, segnali);
               [t,y]=getpoints(PL.(s));
            else
               s = "LC"; %<- default
               [t,y]=getpoints(PL.(s));
            end
            if isvector(lim)
                if length(lim)<2
                    y=y(t>=lim);
                elseif length(lim)==2
                    y=y(t>=lim(1) & t<=lim(2));
                end
            end
        end
        m=mean(y);
        r=rms(y);
        s=std(y);
    end
    

    end
end

